import createVideoElement from "./create-video-element.js";
import createCategory from "./create-category.js";
import {SOUND_PACK} from "./sfx-pack.js";
import createVideoLinkElement from "./create-video-link-element.js";


const SFX = {
    "SFX compatible": {
        packFromDatabase: {
            name: "SFX compatible",
            motionBroSfxCompatible: true,
            for: "AE",

        },
        categories: [
            createCategory({
                categoryName: "First Cat",
                packFolderName: "SFX compatible",
                children: [
                    createVideoElement("Footage with Marker 3", "First Cat", "SFX compatible"),
                    createVideoElement("[Ease in] - Dom", "First Cat", "SFX compatible")
                ]
            }),
            createCategory({
                categoryName: "Second Cat",
                packFolderName: "SFX compatible",
                children: [
                    createVideoElement("Footage with Marker 3", "First Cat", "SFX compatible"),
                    createVideoElement("[Ease in] - Dom", "First Cat", "SFX compatible")
                ]
            }),
        ]
    },
    "SFX compatible 2": {
        packFromDatabase: {
            name: "SFX compatible 2",
            motionBroSfxCompatible: true,
            for: ["AE", "PP"],
        },
        categories: [
            createCategory({
                categoryName: "First Cat",
                packFolderName: "SFX compatible 2",
                children: [
                    createVideoElement("Footage with Marker 3", "First Cat", "SFX compatible 2"),
                    createVideoElement("[Ease in] - Dom", "First Cat", "SFX compatible 2")
                ]
            }),
            createCategory({
                categoryName: "Second Cat",
                packFolderName: "SFX compatible 2",
                children: [
                    createVideoElement("Footage with Marker 3", "First Cat", "SFX compatible 2"),
                    createVideoElement("[Ease in] - Dom", "First Cat", "SFX compatible 2")
                ]
            }),
        ]
    },
    "SFX default Emerald": {
        packFromDatabase: {
            name: "SFX default Emerald",
            motionBroSfxCompatible: true,
            motionBroSfxDefault: "Emerald",
        },
        categories: [
            createCategory({
                categoryName: "First Cat",
                packFolderName: "SFX default Emerald",
                children: [
                    createVideoElement("Footage with Marker 3", "First Cat", "SFX default Emerald"),
                    createVideoElement("[Ease in] - Dom", "First Cat", "SFX default Emerald")
                ]
            }),
            createCategory({
                categoryName: "Second Cat",
                packFolderName: "SFX default Emerald",
                children: [
                    createVideoElement("Footage with Marker 3", "First Cat", "SFX default Emerald"),
                    createVideoElement("[Ease in] - Dom", "First Cat", "SFX default Emerald")
                ]
            }),
        ]
    },
}


export const VideoWithThumbnails = "Video With Thumbnails"
const FirstCatName = "First Cat"

const ELEMENTS = {
    "Video With Thumbnails": {
        packFromDatabase: {
            name: VideoWithThumbnails,
        },
        categories: [
            createCategory({
                categoryName: FirstCatName,
                packFolderName: VideoWithThumbnails,
                children: [
                    createVideoElement("Footage with Marker", FirstCatName, VideoWithThumbnails, undefined, 270, 480, "thumbnails 1.jpg"),
                    createVideoElement("Footage with Marker 1", FirstCatName, VideoWithThumbnails, undefined, 270, 480, "thumbnails 2.jpg"),
                    createVideoElement("Footage with Marker 2", FirstCatName, VideoWithThumbnails, undefined, 270, 480, "thumbnails 3.jpg"),
                    createVideoElement("Footage with Marker 3", FirstCatName, VideoWithThumbnails, undefined, 270, 480, "thumbnails 4.jpg"),
                    createVideoElement("Footage with Marker 4", FirstCatName, VideoWithThumbnails, undefined, 270, 480, "thumbnails 1.jpg"),
                    createVideoElement("Broken Image", FirstCatName, VideoWithThumbnails, undefined, 270, 480, "t.jpg"),
                    createVideoElement("Footage with Marker 6", FirstCatName, VideoWithThumbnails),
                    createVideoElement("Footage with Marker 7", FirstCatName, VideoWithThumbnails),
                    createVideoElement("Footage with Marker 8", FirstCatName, VideoWithThumbnails),
                    createVideoElement("Footage with Marker 9", FirstCatName, VideoWithThumbnails),
                    createVideoElement("Footage with Marker 10", FirstCatName, VideoWithThumbnails),
                ]
            }),
        ]
    }
}

const LINKS = {
    "Links": {
        packFromDatabase: {
            name: "Links",
            motionBroSfxCompatible: true
        },
        categories: [
            createCategory({
                categoryName: "First Cat",
                packFolderName: "Links",
                children: [
                    createVideoLinkElement("Default video link", "Links", "First Cat"),
                    createVideoLinkElement("Link 2", "Links", "First Cat"),
                    createVideoLinkElement("Link 3", "Links", "First Cat"),
                    createVideoLinkElement("Link 4", "Links", "First Cat"),
                    createVideoLinkElement("Link 5", "Links", "First Cat"),
                ],
                settings: {
                    fitResolutionToFrame: true,
                    collapseTransformations: true,
                    maxPreviewSize: true
                },
            })
        ]
    }

}


export const DefaultCategorySettings = "Default Category Settings"

const SETTINGS = {
    "Default Category Settings": {
        packFromDatabase: {
            name: DefaultCategorySettings
        },
        categories: [
            createCategory({
                categoryName: "First Cat",
                packFolderName: DefaultCategorySettings,
                children: [
                    createVideoElement("El 1", "First Cat", DefaultCategorySettings),
                    createVideoElement("El 2", "First Cat", DefaultCategorySettings)
                ],
                settings: {
                    presetType: "cutTransition",
                    fitResolutionToFrame: true,
                    collapseTransformations: true,
                    timeRemapKeyframes: true,
                    durationBar: true,
                    compactDropdown: true,
                    compactDropdownOptions: [
                        "ON",
                        "OFF"
                    ],
                    compactDropdownOptionsDefault: 2
                }
            }),
        ]
    },
    "Settings in SubCategory": {
        packFromDatabase: {
            name: "Settings in SubCategory",
            settings: {
                abberationDropdown: true,
                abberationDropDownTitle: "Abberation",
                abberationDropdownOptions: [
                    "ON",
                    "OFF"
                ]
            }
        },
        categories: [
            createCategory({
                categoryName: "Category",
                packFolderName: "Settings in SubCategory",
                children: [
                    createCategory({
                        categoryName: "Sub Category 1 with Settings",
                        packFolderName: "Settings in SubCategory",
                        parentPath: ["Category"],
                        settings: {
                            compactDropdown: true,
                            compactDropdownOptions: [
                                "ON",
                                "OFF"
                            ],
                            compactDropdownOptionsDefault: 2
                        },
                        children: [
                            createVideoElement("El 1", "Category\\Sub Category 1", "Settings in SubCategory"),
                            createVideoElement("El 2", "Category\\Sub Category 1", "Settings in SubCategory"),
                        ],
                    }),
                    createCategory({
                        categoryName: "Sub Category 2",
                        packFolderName: "Settings in SubCategory",
                        parentPath: ["Category"],
                        children: [
                            createCategory({
                                categoryName: "Sub Sub Category 1",
                                packFolderName: "Settings in SubCategory",
                                parentPath: ["Category", "Sub Category 2"],
                                children: [
                                    createVideoElement("El 1", "Category\\Sub Category 2\\Sub Sub Category 1", "Settings in SubCategory"),
                                    createVideoElement("El 2", "Category\\Sub Category 2\\Sub Sub Category 1", "Settings in SubCategory"),
                                    createVideoElement("El 3", "Category\\Sub Category 2\\Sub Sub Category 1", "Settings in SubCategory"),
                                ],
                            })
                        ],
                    }),
                ],
            })
        ]
    },
    "Settings on Pack Level": {
        packFromDatabase: {
            name: "Settings on Pack Level",
            settings: {
                compactDropdown: true,
                compactDropdownOptions: ["ON", "OFF"],
                durationBar: true,
            }
        },
        categories: [
            createCategory({
                categoryName: "First Cat",
                packFolderName: "Settings on Pack Level",
                children: [
                    createVideoElement("El 1", "First Cat", "Settings on Pack Level"),
                    createVideoElement("El 2", "First Cat", "Settings on Pack Level")
                ]
            }),
            createCategory({
                categoryName: "Second Cat",
                packFolderName: "Settings on Pack Level",
                children: [
                    createVideoElement("El 1", "Second Cat", "Settings on Pack Level"),
                    createVideoElement("El 2", "Second Cat", "Settings on Pack Level")
                ]
            }),
        ]
    },
    "Settings on Pack Level 2": {
        packFromDatabase: {
            name: "Settings on Pack Level 2",
            settings: {
                durationBar: true,
                compactDropdown: true,
                compactDropdownOptions: ["ON", "OFF"],
            }
        },
        categories: [
            createCategory({
                categoryName: "First Cat",
                packFolderName: "Settings on Pack Level 2",
                children: [
                    createVideoElement("El 1", "First Cat", "Settings on Pack Level 2"),
                    createVideoElement("El 2", "First Cat", "Settings on Pack Level 2")
                ]
            }),
        ]
    },
}


const MANY_CATEGORIES = {
    "Many Categories": {
        packFromDatabase: {
            name: "Many Categories",
        },
        categories: [
            createCategory({
                categoryName: "First Cat",
                packFolderName: "Many Categories",
                children: [
                    createVideoElement("El 1", "First Cat", "Many Categories"),
                ]
            }),
            createCategory({
                categoryName: "Second Cat",
                packFolderName: "Many Categories",
                children: [
                    createVideoElement("El 1", "Second Cat", "Many Categories"),
                ]
            }),
            createCategory({
                categoryName: "Cat 3",
                packFolderName: "Many Categories",
                children: [
                    createCategory({
                        categoryName: "Sub Cat 1",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 1", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 2",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 2", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 3",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 3", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 4",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 4", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 5",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 5", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 6",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 6", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 7",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 7", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 8",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 8", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 9",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 9", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 10",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 10", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 11",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 11", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 12",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 12", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 13",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 13", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 14",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 14", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 15",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 15", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 16",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 16", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 17",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 17", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 18",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 18", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 19",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 19", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 20",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 3"],
                        children: [
                            createVideoElement("El 1", "Cat 3\\Sub Cat 20", "Many Categories"),
                        ]
                    }),
                ]
            }),
            createCategory({
                categoryName: "Cat 4",
                packFolderName: "Many Categories",
                children: [
                    createVideoElement("El 1", "Cat 4", "Many Categories"),
                ]
            }),
            createCategory({
                categoryName: "Cat 5",
                packFolderName: "Many Categories",
                children: [
                    createVideoElement("El 1", "Cat 5", "Many Categories"),
                ]
            }),
            createCategory({
                categoryName: "Cat 6",
                packFolderName: "Many Categories",
                children: [
                    createVideoElement("El 1", "Cat 6", "Many Categories"),
                ]
            }),
            createCategory({
                categoryName: "Cat 7",
                packFolderName: "Many Categories",
                children: [
                    createVideoElement("El 1", "Cat 7", "Many Categories"),
                ]
            }),
            createCategory({
                categoryName: "Cat 8",
                packFolderName: "Many Categories",
                children: [
                    createVideoElement("El 1", "Cat 8", "Many Categories"),
                ]
            }),
            createCategory({
                categoryName: "Cat 9",
                packFolderName: "Many Categories",
                children: [
                    createVideoElement("El 1", "Cat 9", "Many Categories"),
                ]
            }),
            createCategory({
                categoryName: "Cat 10",
                packFolderName: "Many Categories",
                children: [
                    createVideoElement("El 1", "Cat 10", "Many Categories"),
                ]
            }),
            createCategory({
                categoryName: "Cat 11",
                packFolderName: "Many Categories",
                children: [
                    createVideoElement("El 1", "Cat 11", "Many Categories"),
                ]
            }),
            createCategory({
                categoryName: "Cat 12",
                packFolderName: "Many Categories",
                children: [
                    createVideoElement("El 1", "Cat 12", "Many Categories"),
                ]
            }),
            createCategory({
                categoryName: "Cat 13",
                packFolderName: "Many Categories",
                children: [
                    createCategory({
                        categoryName: "Sub Cat 1",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 13"],
                        children: [
                            createVideoElement("El 1", "Cat 13\\Sub Cat 1", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 2",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 13"],
                        children: [
                            createVideoElement("El 1", "Cat 13\\Sub Cat 2", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 3",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 13"],
                        children: [
                            createVideoElement("El 1", "Cat 13\\Sub Cat 3", "Many Categories"),
                        ]
                    }),
                    createCategory({
                        categoryName: "Sub Cat 4",
                        packFolderName: "Many Categories",
                        parentPath: ["Cat 13"],
                        children: [
                            createVideoElement("El 1", "Cat 13\\Sub Cat 4", "Many Categories"),
                        ]
                    }),
                ]
            }),
            createCategory({
                categoryName: "Cat 14",
                packFolderName: "Many Categories",
                children: [
                    createVideoElement("El 1", "Cat 14", "Many Categories"),
                ]
            }),
        ]
    }

}

const PREVIEW = {
    "Preview fix": {
        packFromDatabase: {
            name: "Preview fix",
        },
        categories: [
            createCategory({
                categoryName: "Makeup",
                packFolderName: "Preview fix",
                children: [
                    createVideoElement("Animal", "Makeup", "Preview fix", "FTSP - Makeup Animal - Bulldog.mp4"),
                    createVideoElement("Bulldog", "Makeup", "Preview fix", "FTSP - Makeup Composite - Bulldog.mp4", 270, 480, "FTSP - Makeup Composite - Bulldog.jpg")
                ]
            }),
        ]
    }
}

const PACKS_CONFIG: any = {
    ...ELEMENTS,
    ...SFX,
    ...SETTINGS,
    ...MANY_CATEGORIES,
    ...SOUND_PACK,
    ...LINKS,
    ...PREVIEW
}

export default PACKS_CONFIG